/*
 * Diese Datei ist Teil des GDialog Projektes:
 * "Gigaset-Erweiterung fr ProjectX"
 * 
 * Das GDialog Projekt ist freigegeben unter
 * der GNU Public Licence (GPL), deren Text sich in
 * dem Quellen-Verzeichnis befindet. Ist er dort nicht
 * mehr vorhanden, so kann er unter http://www.gnu.org/licenses/gpl.html
 * eingesehen werden.
 */
package de.m740.projectx.gigaset;

import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.gui.FtpChooser;
import net.sourceforge.dvb.projectx.xinput.XInputDirectory;
import net.sourceforge.dvb.projectx.xinput.XInputFile;
import net.sourceforge.dvb.projectx.xinput.ftp.FtpVO;

import org.apache.commons.net.ftp.FTPClient;

/**
 * 
 * 
 * @author arnaud
 * 
 */
public class GPanelFTP extends GPanelAbstract implements ChangeListener {
    /**
     * 
     */
    private static final long serialVersionUID = 1L;

    // ----------------------------------------------------------
    public static class XInputFileComparatorAZ implements Comparator {

        public int compare(Object arg0, Object arg1) {
            try {
                XInputFile tmpFile0 = (XInputFile) arg0;
                XInputFile tmpFile1 = (XInputFile) arg1;
                String tmpFN0 = tmpFile0.getName();
                String tmpFN1 = tmpFile1.getName();
                return tmpFN0.compareTo(tmpFN1);
            } catch (Exception e) {
                // ignore
            }
            return 0;
        }

    }

    // ----------------------------------------------------------
    class XInputFileComparatorZA implements Comparator {

        public int compare(Object arg0, Object arg1) {
            try {
                return -(getXFileComparatorAZ().compare(arg0, arg1));
            } catch (Exception e) {
                // ignore
            }
            return 0;
        }

    }

    // ----------------------------------------------------------

    protected JButton btnFtpChooser = new JButton(GStrings
            .getString("gdialog.ftp.chooser"));

    private JButton btnRefresh = new JButton(GStrings
            .getString("gdialog.refresh"));

    protected XInputDirectory aCridDirectory = null;

    private XInputFileComparatorAZ aXFileComparatorAZ = null;

    private XInputFileComparatorZA aXFileComparatorZA = null;

    private GFTPHandler aFTPHandler = null;

    public GPanelFTP(GDialog inpDialog) {
        super();
        setDialog(inpDialog);
        buildPanel();
    }

    private void buildPanel() {
        setLayout(new BorderLayout());
        // Buttons top
        JPanel tmpPanelTop = new JPanel(new GridLayout(1, 2));
        tmpPanelTop.add(btnFtpChooser);
        tmpPanelTop.add(btnRefresh);
        btnRefresh.setEnabled(true);
        // Buttons oben
        add(tmpPanelTop, BorderLayout.NORTH);
        // Aufnahmetabelle
        add(spAufnahmen, BorderLayout.CENTER);

        ListSelectionModel tmpSelectionModel = aTableAufnahmen
                .getSelectionModel();
        tmpSelectionModel.addListSelectionListener(new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    doEnabled();
                }
            }

        });

        aTableAufnahmen.addMouseListener(new MouseAdapter() {
            public void mouseClicked(MouseEvent event) {
                mouseClick(event);
            }
        });

        btnFtpChooser.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                connect();
            }
        });

        btnRefresh.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                if (aCridDirectory == null) {
                    autoConnect();
                } else {
                    sucheAufnahmen();
                }
            }
        });

    }

    /*
     * (Kein Javadoc)
     * 
     * @see de.m740.projectx.gigaset.GChooserIF#getSelectedRecording()
     */
    public List getSelectedRecording() {
        List tmpList = null;
        try {
            GAufnahmeIF tmpAufnahme = getSelectedAufnahme();
            if (tmpAufnahme == null) {
                return null;
            }
            GConsole.setMessage("Get selected recording: "
                    + tmpAufnahme.getTitel());
            tmpList = tmpAufnahme.getMpgFiles();
            if (tmpList != null && tmpList.size() > 1) {
                Collections.sort(tmpList, getXFileComparatorAZ());
            }
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return tmpList;
    }

    protected void connect() {
        try {
            // Add ftp server directory to autoload list
            FtpChooser tmpChooser = new FtpChooser();

            tmpChooser.pack();
            tmpChooser.setVisible(true);

            XInputDirectory tmpXInputDirectory = tmpChooser
                    .getXInputDirectory();
            aCridDirectory = tmpXInputDirectory;

            if (tmpChooser.isTested() && tmpXInputDirectory != null) {
                sucheAufnahmen();
            }

        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
    }

    protected boolean autoConnect2() {
        boolean isTested = false;
        try {
            GConsole.setMessage("Try to connect to ftp-server...");

            final String tmpBaseKey = "FtpServer.";

            String tmpServer = Common.getSettings().getProperty(
                    tmpBaseKey + "Server");

            String tmpPort = Common.getSettings().getProperty(
                    tmpBaseKey + "Port");

            String tmpUser = Common.getSettings().getProperty(
                    tmpBaseKey + "User");

            String tmpPassword = Common.getSettings().getProperty(
                    tmpBaseKey + "Password");

            String tmpDirectory = Common.getSettings().getProperty(
                    tmpBaseKey + "Directory");

            FtpVO ftpVO = new FtpVO(tmpServer, tmpUser, tmpPassword,
                    tmpDirectory, tmpPort, null);
            XInputDirectory tmpXInputDirectory = new XInputDirectory(ftpVO);

            isTested = tmpXInputDirectory.test();
            GConsole.setMessage(tmpXInputDirectory.getLog());
            GConsole.setMessage(tmpXInputDirectory.getTestMsg());

            aCridDirectory = tmpXInputDirectory;

            if (isTested) {
                sucheAufnahmen0();
            }
            return isTested;

        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        } finally {
            if (!isTested) {
                btnFtpChooser.setEnabled(true);
            }
        }
        return false;
    }

    /**
     * 
     * @return true/false
     */
    public boolean isAutoConnectOn() {
        try {
            if (Common.getSettings().getBooleanProperty(
                    GDialog.PROPERTY_FTP_AUTOCONNECT, false)) {
                return true;
            }
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return false;
    }
    
    /**
     * 
     *
     */
    public void autoConnect() {
        try {
            if (!isAutoConnectOn()) {
                return;
            }
            Runnable tmpRunnable = new Runnable() {
                public void run() {
                    autoConnect2();
                }
            };
            btnFtpChooser.setEnabled(false);
            btnRefresh.setEnabled(false);
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(tmpRunnable);
            } else {
                new Thread(tmpRunnable).start();
            }
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
    }

    private void sucheAufnahmen0() {
        try {
            btnFtpChooser.setEnabled(false);
            btnRefresh.setEnabled(false);
            final XInputDirectory tmpXInputDirectory = aCridDirectory;

            if (tmpXInputDirectory != null) {

                Runnable tmpRunnable = new Runnable() {
                    public void run() {
                        sucheAufnahmen1(tmpXInputDirectory);
                    }

                };
                new Thread(tmpRunnable).start();
            }

        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
    }

    public void sucheAufnahmen() {
        try {
            GConsole.clear();
            sucheAufnahmen0();
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
    }

    protected void sucheAufnahmen2(XInputDirectory inpDirectory) {
        clearSelection();
        aTableModel.clear();
        aTableModel.fireTableDataChanged();
        fireStateChanged();
        if (inpDirectory == null) {
            return;
        }
        //
        ListSelectionModel tmpListSelectionModel = aTableAufnahmen
                .getSelectionModel();
        // aTableAufnahmen = new GTable(aTableModel);
        aTableAufnahmen.setSelectionModel(tmpListSelectionModel);
        spAufnahmen.setViewportView(aTableAufnahmen);
        //
        XInputFile[] tmpFiles = inpDirectory.getFiles();
        int anzf = (tmpFiles == null) ? 0 : tmpFiles.length;
        List tmpCridList = null;
        for (int i = 0; i < anzf; i++) {
            XInputFile tmpFile = tmpFiles[i];
            String tmpFN = tmpFile.getName();
            if (tmpFN.toLowerCase().endsWith(".crid")) {
                if (tmpCridList == null) {
                    tmpCridList = new ArrayList();
                }
                tmpCridList.add(tmpFile);
            }
        } // for i
        tmpFiles = null;
        if (tmpCridList == null) {
            return;
        }
        anzf = tmpCridList.size();
        if (anzf > 1) {
            Collections.sort(tmpCridList, getXFileComparatorZA());
            setSortSelector(SORT_FILES_NO);
        }
        aAufnahmen = new ArrayList(anzf);
        HashMap tmpHash = new HashMap(anzf);
        for (int i = 0; i < anzf; i++) {
            try {
                XInputFile tmpFile = (XInputFile) tmpCridList.get(i);
                GAufnahmeFTP tmpAufnahme = new GAufnahmeFTP(tmpFile,
                        inpDirectory);
                if (tmpAufnahme.isValid()) {
                    aAufnahmen.add(tmpAufnahme);
                    addAufnahme(i, tmpAufnahme, tmpHash);
                    // Listener anmelden,
                    // der uns ber das Einlesen der MPGs informiert
                    tmpAufnahme.addChangeListener(this);
                } else {
                    GConsole.setMessage("Invalid file " + tmpFile.getName()
                            + " skipped!");
                }
            } catch (Exception exc) {
                GConsole.setErrorMessage(exc);
            }
        } // for i
        countChildren(GPanelTableIF.SORT_FILES_ON);
        // evtl letzte Tree-nderungen sichtbar machen
        aTableModel.fireTableRowsUpdated(0, aTableModel.getRowCount() - 1);
        tmpHash = null;

        if (aTableModel.getRowCount() == 0) {
            // falls keine Aufnahmen vorh.
            getDialog().zeigeInfos(-1); // soll auch nix angezeigt w.!
        }
    }

    /**
     * 
     * @param inpAufnahmeOrdner
     */
    protected void sucheAufnahmen1(XInputDirectory inpDirectory) {
        try {
            sucheAufnahmen2(inpDirectory);
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        } finally {
            btnFtpChooser.setEnabled(true);
            btnRefresh.setEnabled(true);
        }
    }

    public void deleteSelectedAufnahme() {
        try {
            GAufnahmeIF tmpAufnahme = getSelectedAufnahme();
            if (tmpAufnahme == null) {
                return;
            }
            // int nr = aTableAufnahmen.getSelectedRow();
            XInputFile tmpCridFile = ((GAufnahmeFTP) tmpAufnahme).getCridFile();
            String tmpWarning = "<html>" + tmpAufnahme.getTitel() + "<hr>"
                    + GStrings.getString("gdialog.delete.text") + " "
                    + aCridDirectory.getDirectory() + " :<br>"
                    + tmpCridFile.getName() + "<br>";
            if (tmpAufnahme.istGesperrt()) {
                tmpWarning += "<hr> "
                        + GStrings.getString("gdialog.delete.locked") + " <hr>";
            }
            tmpWarning += "</html>";

            Toolkit.getDefaultToolkit().beep();
            if (JOptionPane.showConfirmDialog(null, tmpWarning, GStrings
                    .getString("gdialog.delete"), JOptionPane.WARNING_MESSAGE) != JOptionPane.OK_OPTION) {
                return;
            }
            GFTPHandler tmpHandler = getFTPHandler();
            FtpVO tmpVO = tmpHandler.makeVOFrom(aCridDirectory);
            String tmpWD = aCridDirectory.getDirectory();
            FTPClient tmpClient = tmpHandler.openClient(tmpVO);
            boolean ok = tmpClient.changeWorkingDirectory(tmpWD);
            String tmpFN = tmpCridFile.getName();
            if (ok) {
                ok = tmpClient.deleteFile(tmpFN);
                if (ok) {
                    aAufnahmen.remove(tmpAufnahme);
                    // aTableModel.removeRow(nr);
                    // aTableModel.fireTableRowsDeleted(nr, nr);
                    sortiereAufnahmen(getSortSelector());
                }
            }
            tmpHandler.closeClient(tmpClient);
            GConsole.setInfo(tmpFN + (ok ? " " : " NOT ") + "deleted");
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
    }

    public void doEnabled() {
        GDialog tmpDialog = getDialog();
        int index = aTableAufnahmen.getSelectedRow();
        boolean enable = (index >= 0);
        tmpDialog.btnPrintEPG.setEnabled(enable);
        tmpDialog.aItemPlayMPC.setEnabled(false);
        tmpDialog.aItemLoeschen.setEnabled(enable);
        tmpDialog.aItemReread.setEnabled(enable);
        tmpDialog.btnAuswaehlen.setEnabled(enable);
        tmpDialog.aItemAuswaehlen.setEnabled(enable);
        tmpDialog.btnHinzufuegen.setEnabled(enable);
        tmpDialog.aItemHinzufuegen.setEnabled(enable);
        tmpDialog.zeigeInfos(index);
    }

    private XInputFileComparatorZA getXFileComparatorZA() {
        if (aXFileComparatorZA == null) {
            aXFileComparatorZA = new XInputFileComparatorZA();
        }
        return aXFileComparatorZA;
    }

    protected XInputFileComparatorAZ getXFileComparatorAZ() {
        if (aXFileComparatorAZ == null) {
            aXFileComparatorAZ = new XInputFileComparatorAZ();
        }
        return aXFileComparatorAZ;
    }

    /**
     * 
     */
    public List getUsedRecDirectories() {
        List tmpList = null;
        int anza = (aAufnahmen == null) ? 0 : aAufnahmen.size();
        for (int i = 0; i < anza; i++) {
            GAufnahmeIF tmpAufnahmeIF = (GAufnahmeIF) aAufnahmen.get(i);
            if (tmpAufnahmeIF instanceof GAufnahmeFTP) {
                GAufnahmeFTP tmpAufnahme = (GAufnahmeFTP) tmpAufnahmeIF;
                XInputDirectory[] tmpDirs = tmpAufnahme
                        .getFmpgDirectories(true);
                int anzd = (tmpDirs == null) ? 0 : tmpDirs.length;
                for (int j = 0; j < anzd; j++) {
                    XInputDirectory tmpDir = tmpDirs[j];
                    if (tmpDir == null) {
                        continue;
                    }
                    if (tmpList == null) {
                        tmpList = new ArrayList();
                    }
                    tmpList.add(tmpDir);
                    GConsole.setMessage("Used dir: " + tmpDir.getDirectory());
                } // for j
            } // if FTP
        } // for i
        return tmpList;
    }

    private XInputDirectory makeRecDirectory(String inpDateinamenbasis) {
        try {
            XInputDirectory tmpXDirectory = aCridDirectory;
            String tmpAufnahmeverzeichnis = tmpXDirectory.getDirectory();
            String tmpServer = tmpXDirectory.getServer();
            String tmpUser = tmpXDirectory.getUser();
            String tmpPassword = tmpXDirectory.getPassword();
            String tmpDirectory = tmpAufnahmeverzeichnis;
            String tmpLim = "/";
            if (tmpDirectory.indexOf('\\') >= 0) {
                //tmpLim = "\\";
            }                    
            if (!tmpDirectory.endsWith(tmpLim)) {
                tmpDirectory += tmpLim;
            }
            tmpDirectory += ".rec";
            String tmpPort = tmpXDirectory.getPort();
            FtpVO tmpVO = new FtpVO(tmpServer, tmpUser, tmpPassword,
                    tmpDirectory, tmpPort, null);
            XInputDirectory tmpIDirectory = new XInputDirectory(tmpVO);
            if (tmpIDirectory.test()) {
                return tmpIDirectory;
            }
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return null;
    }

    private boolean missing(List inpList, Object inpObj) {
        try {
            String tmpFN = inpObj.toString();
            int anz = (inpList == null) ? 0 : inpList.size();
            for (int i = 0; i < anz; i++) {
                Object tmpObj = inpList.get(i);
                String tmpStr = (tmpObj == null) ? "" : tmpObj.toString();
                if (tmpStr.equals(tmpFN)) {
                    return false;
                }
            } // for i
            return true;
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return false; // error
    }

    /**
     * 
     * @param inpList
     *            List of File (fmpg-dirs)
     * @return XInputDirectory (.rec-directory)
     */
    public Object getLostDirectories(List inpList) {
        XInputDirectory tmpRecDir = null;
        try {
            inpList.clear();
            tmpRecDir = aCridDirectory;
            if (tmpRecDir == null) {
                return null;
            }
            tmpRecDir = makeRecDirectory(tmpRecDir.getDirectory());
            if (tmpRecDir == null) {
                return null;
            }
            //
            GConsole.setMessage("*** Start searching lost directories ***");
            XInputFile[] tmpFilesInRecDir = new GFTPHandler().getFilesAndDirectories(tmpRecDir);
            //
            List tmpUsedDirList = getUsedRecDirectories();
            int anzd = (tmpUsedDirList == null) ? 0 : tmpUsedDirList.size();
            GConsole.setMessage(anzd + " used directories read");
            if (tmpUsedDirList == null) {
                return null;
            }
            anzd = (tmpFilesInRecDir == null) ? 0 : tmpFilesInRecDir.length;
            GConsole.setMessage(anzd + " files (all types) found in .rec-dir");
            //
            // change array to list
            List tmpList = null;
            for (int i = 0; i < anzd; i++) {
                XInputFile tmpFile = tmpFilesInRecDir[i];
                String tmpFN = tmpFile.getName();
                if (tmpFN.toLowerCase().endsWith(".fmpg")) {
                    if (tmpList == null) {
                        tmpList = new ArrayList();
                    }
                    tmpList.add(tmpFile);
                    GConsole.setInfo(tmpFN);
                }
            } // for

            anzd = (tmpList == null) ? 0 : tmpList.size();
            GConsole.setMessage(anzd + " fmpg-files found in .rec-dir");
            // nun vergleichen
            for (int i = 0; i < anzd; i++) {
                Object tmpObject = tmpList.get(i);
                if (missing(tmpUsedDirList, tmpObject)) {
                    inpList.add(tmpObject);
                    GConsole.setMessage("Lost dir: " + tmpObject.toString());
                }
            } // for i
            anzd = (inpList == null) ? 0 : inpList.size();
            GConsole.setMessage(anzd + " lost directories found");
            GConsole.setMessage("*** End of searching lost directories ***");
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return tmpRecDir;

    }

    /**
     * @return fTPHandler
     */
    protected GFTPHandler getFTPHandler() {
        if (aFTPHandler == null) {
            aFTPHandler = new GFTPHandler();
        }
        return aFTPHandler;
    }

    /*
     * (Kein Javadoc)
     * 
     * @see javax.swing.event.ChangeListener#stateChanged(javax.swing.event.ChangeEvent)
     */
    public void stateChanged(ChangeEvent inpE) {
        try {
            // es sind MPGs fertig eingelesen worden
            // (von irgendeiner(!) Aufnahme)
            GDialog tmpDialog = getDialog();
            int index = aTableAufnahmen.getSelectedRow();
            tmpDialog.zeigeInfos(index);
            aTableModel.fireTableRowsUpdated(0, aTableModel.getRowCount());
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
    }

}
